/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class Selection
implements Predicate<BlockPos> {
    public static Selection of(BoundingBox bb) {
        return new Simple(bb);
    }

    public abstract Selection add(Selection var1);

    public abstract Selection substract(Selection var1);

    public abstract Selection copy();

    public abstract Vec3 getCenter();

    public abstract void forEach(Consumer<BlockPos> var1);

    public abstract Outline.OutlineParams makeOutline(Outliner var1, Object var2);

    public Outline.OutlineParams makeOutline(Outliner outliner) {
        return this.makeOutline(outliner, this);
    }

    private static class Simple
    extends Selection {
        private BoundingBox bb;
        private AABB aabb;

        public Simple(BoundingBox bb) {
            this.bb = bb;
            this.aabb = this.getAABB();
        }

        @Override
        public boolean test(BlockPos t) {
            return this.bb.m_71051_((Vec3i)t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            BlockPos.m_121919_((BoundingBox)this.bb).forEach(callback);
        }

        @Override
        public Vec3 getCenter() {
            return this.aabb.m_82399_();
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, this.aabb);
        }

        private AABB getAABB() {
            return new AABB((double)this.bb.m_162395_(), (double)this.bb.m_162396_(), (double)this.bb.m_162398_(), (double)(this.bb.m_162399_() + 1), (double)(this.bb.m_162400_() + 1), (double)(this.bb.m_162401_() + 1));
        }

        @Override
        public Selection copy() {
            return new Simple(new BoundingBox(this.bb.m_162395_(), this.bb.m_162396_(), this.bb.m_162398_(), this.bb.m_162399_(), this.bb.m_162400_(), this.bb.m_162401_()));
        }
    }

    private static class Compound
    extends Selection {
        Set<BlockPos> posSet;
        Vec3 center;

        public Compound(Simple initial) {
            this.posSet = new HashSet<BlockPos>();
            this.add(initial);
        }

        private Compound(Set<BlockPos> template) {
            this.posSet = new HashSet<BlockPos>(template);
        }

        @Override
        public boolean test(BlockPos t) {
            return this.posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> this.posSet.add(p.m_7949_()));
            this.center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> this.posSet.remove(p.m_7949_()));
            this.center = null;
            return this;
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            this.posSet.forEach(callback);
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, this.posSet);
        }

        @Override
        public Vec3 getCenter() {
            return this.center == null ? (this.center = this.evalCenter()) : this.center;
        }

        private Vec3 evalCenter() {
            Vec3 center = Vec3.f_82478_;
            if (this.posSet.isEmpty()) {
                return center;
            }
            for (BlockPos blockPos : this.posSet) {
                center = center.m_82549_(Vec3.m_82528_((Vec3i)blockPos));
            }
            center = center.m_82490_((double)(1.0f / (float)this.posSet.size()));
            return center.m_82549_(new Vec3(0.5, 0.5, 0.5));
        }

        @Override
        public Selection copy() {
            return new Compound(this.posSet);
        }
    }
}

